/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor
{

    using System;
    using System.Collections.Generic;
    using Owasp.Esapi;

/**
 * This class : the SecurityConfiguration.Threshold class, 
 * which is part of Esapi.  This class adds the appropriate 
 * member variables to represent the handling of disabling
 * components for a specific user, as well as disabling 
 * components for the application altogether.  
 * 
 * @author Michael Coates (michael.coates .at. owasp.org) 
 *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton (jtmelton .at. gmail.com)
 *         <a href="http://www.jtmelton.com/">jtmelton</a>
 * @since February 24, 2010
 * @see org.owasp.esapi.SecurityConfiguration.Threshold
 */
public class AppSensorThreshold : Threshold {
	
	/** The default time duration to consider for a detection point that does not specify a duration */
	public const int DEFAULT_TIME_DURATION = 0;
	
	/** The span of time to disable a component */
	public int disableComponentDuration = DEFAULT_TIME_DURATION;
	
	/** The measure of time to disable a component, if timeSpan is 30 and timeMeasure is "s", it would be for 30 seconds. 
	 * Supported are (s,m,h,d) (second,minute,hour,day) 
	 */
    public TimeIncrement disableComponentTimeScale = TimeIncrement.Second;

	/** The span of time to disable a component for a single user */
	public int disableComponentForUserDuration = DEFAULT_TIME_DURATION;
	
	/** The measure of time to disable a component for a single user, if timeSpan is 30 and timeMeasure is "s", it would be for 30 seconds. 
	 * Supported are (s,m,h,d) (second,minute,hour,day) 
	 */
    public TimeIncrement disableComponentForUserTimeScale = TimeIncrement.Second;
	
	/**
	 * Constructs a threshold that is composed of its name, its threshold count, the time window for
	 * the threshold, and the actions to take if the threshold is triggered.
	 * 
	 * @param name The name of this threshold.
	 * @param count The count at which this threshold is triggered.
	 * @param interval The time frame within which 'count' number of actions has to be detected in order to
	 * trigger this threshold.
	 * @param actions The list of actions to take if the threshold is met.
	 * @param timeSpan The span of time to disable the component.
	 * @param timeMeasure The measure of time to disable the component.
	 */
	public AppSensorThreshold(String name, int count, long interval, ICollection<String> actions, 
			int disableComponentDuration, TimeIncrement disableComponentTimeScale,
            int disableComponentForUserDuration, TimeIncrement disableComponentForUserTimeScale) :
        base(name, count, interval, actions)
    {
		this.disableComponentDuration = disableComponentDuration;
		this.disableComponentTimeScale = disableComponentTimeScale;
		this.disableComponentForUserDuration = disableComponentForUserDuration;
		this.disableComponentForUserTimeScale = disableComponentForUserTimeScale;
	}
}
}